package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Codrac_chassis extends Codrac_models
{
	public Codrac_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;

		vehicleName = vendorName = "Codrac";
		name = getName();
		
		rID_blueprint = cars.cat_02.Codrac:0x018Ar;
		defColorIndex = GameLogic.CARCOLOR_GRAY;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;

		value = 5450;
 
		fully_stripped_drag = 0.55;
		min_drag = 0.335;
		drag_reduction_mul = 1.0;
		
		parts_shop_sml = new int[4];
		parts_shop_sml[0] = cars.cat_02.Codrac:0x111Ar; //Left taillight dark
		parts_shop_sml[1] = cars.cat_02.Codrac:0x111Fr; //Right taillight dark
		parts_shop_sml[2] = cars.cat_02.Codrac:0x1121r; //Left blinker dark
		parts_shop_sml[3] = cars.cat_02.Codrac:0x1123r; //Right blinker dark
		
		parts_shop_big = new int[2];
		parts_shop_big[0] = cars.cat_02.Codrac:0x013Ar; //Left exhaust
		parts_shop_big[1] = cars.cat_02.Codrac:0x0139r; //Right exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_02.codrac:0x00000110r, "FL door", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x00000111r, "FL seat", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x00000113r, "FR door", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x00000114r, "FR seat", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x00000116r, "L headlights", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x0000011Cr, "R headlights", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x0000011Dr, "R seats", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x00000120r, "R windshield", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x00000121r, "RL blinker", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x00000122r, "RL window", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x00000123r, "RR blinker", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x00000124r, "RR window", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x00000125r, "trunk", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x00000138r, "F windshield", actcolor, optical, power );
			if (power>=1.4)
				addPart( cars.cat_02.codrac:0x00000139r, "R exhaust pipe", actcolor, optical, power );
			addPart( cars.cat_02.codrac:0x0000013Ar, "L exhaust pipe", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000110r, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000111r, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000113r, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000114r, "FR seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000116r, "L headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x0000011Cr, "R headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x0000011Dr, "R seats", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000120r, "R windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000121r, "RL blinker", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000122r, "RL window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000123r, "RR blinker", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000124r, "RR window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000125r, "trunk", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000138r, "F windshield", actcolor, optical, power );
			if (power>=1.4)
				if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000139r, "R exhaust pipe", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x0000013Ar, "L exhaust pipe", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x0000010Fr, "F bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x00000119r, "L sideskirt", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x0000011Br, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x0000011Er, "R sideskirt", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.codrac:0x0000012Dr, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.codrac:0x00000126r, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_02.codrac:0x0000010Fr, "F bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.codrac:0x0000012Er, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.codrac:0x00000127r, "R bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_02.codrac:0x0000011Br, "R bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.codrac:0x00000133r, "R sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.codrac:0x00000129r, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_02.codrac:0x0000011Er, "R sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.codrac:0x00000130r, "L sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.codrac:0x0000012Ar, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_02.codrac:0x00000119r, "L sideskirt", actcolor, optical, power );
		}

		addPart( cars.cat_02.codrac:0x00000134r, "FR suspension" );
		addPart( cars.cat_02.codrac:0x00000135r, "RL suspension" );
		addPart( cars.cat_02.codrac:0x00000136r, "RR suspension" );
		addPart( cars.cat_02.codrac:0x00000137r, "FL suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );

		} else
		{
			if ( random() > 0.5 ) // Speed 6 //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000BAr, "wheel" );
					addPart( parts.wheels_combo:0x000000BAr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) // Star //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BEr, "wheel" );
					addPart( parts.wheels_combo:0x000000BEr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Br, "wheel" );
					addPart( parts.wheels_combo:0x0000098Br, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
				}
			} else                // Rotor //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B1r, "wheel" );
					addPart( parts.wheels_combo:0x000000B1r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000969r, "wheel" );
					addPart( parts.wheels_combo:0x00000969r, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
				}
			}
		}

		if ( power >= 1.666 ) // Bilstein street racer //
		{
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
		} else
		if ( power >= 1.333 ) // Bilstein aftermarket //
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else                // stock //
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.666 ) // H&R street racer 34000 Nm 14" //
		{
			addPart( parts.running_gear:0x00000210r, "spring" );
			addPart( parts.running_gear:0x00000210r, "spring" );
			addPart( parts.running_gear:0x00000211r, "spring" );
			addPart( parts.running_gear:0x00000211r, "spring" );
		} else
		if ( power >= 1.333 ) // stock 28000Nm 14" //
		{
			addPart( parts.running_gear:0x00000209r, "spring" );
			addPart( parts.running_gear:0x00000209r, "spring" );
			addPart( parts.running_gear:0x0000020Ar, "spring" );
			addPart( parts.running_gear:0x0000020Ar, "spring" );
		} else                // stock 23000Nm 14" //
		{
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
		}

		if ( power >= 1.666 ) // Baer drilled 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000108r, "FL brake" );
			addPart( parts.running_gear:0x00000132r, "FR brake" );
			addPart( parts.running_gear:0x00000136r, "RL brake" );
			addPart( parts.running_gear:0x00000146r, "RR brake" );
		} else
		if ( power >= 1.333 ) // stock varied size 12.0"F 11.5"R //
		{
			addPart( parts.running_gear:0x000021FFr, "FL brake" );
			addPart( parts.running_gear:0x000022FFr, "FR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		} else                // stock universal 11.0"F 11.0"R //
		{
			addPart( parts.running_gear:0x000025FFr, "UL brake" );
			addPart( parts.running_gear:0x000026FFr, "UR brake" );
			addPart( parts.running_gear:0x000025FFr, "UL brake" );
			addPart( parts.running_gear:0x000026FFr, "UR brake" );
		}

		if ( power >= 1.8 ) // supersport //
		{
			addPart( parts.running_gear:0x00000164r, "F swaybar" );
			addPart( parts.running_gear:0x00000181r, "R swaybar" );
		} else
		if ( power >= 1.3 ) // sport //
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		} else              // stock //
		{
			addPart( parts.running_gear:0x000041FFr, "F swaybar" );
			addPart( parts.running_gear:0x000042FFr, "R swaybar" );
		}

		if ( power >= 1.8 ) addPart( parts.engines.V6:0x00000008r, "4.0L V6 engine", actcolor, optical, (power-1.8)/0.2*2 ); else
		if ( power >= 1.6 ) addPart( parts.engines.V6:0x00000007r, "3.3L V6 engine", actcolor, optical, (power-1.6)/0.2*2 ); else
		if ( power >= 1.4 ) addPart( parts.engines.V6:0x00000060r, "2.8L V6 engine", actcolor, optical, (power-1.4)/0.2*2 ); else
		if ( power >= 1.2 ) addPart( parts.engines.I4:0x0000000Br, "2.5L I4 engine", actcolor, optical, (power-1.2)/0.2*2 ); else
		if ( power >= 1 ) addPart( parts.engines.I4:0x0000000Ar, "2.2L I4 engine", actcolor, optical, (power-1)/0.2*2 ); else
		if ( power >= 0.75 ) addPart( parts.engines.I4:0x00000009r, "2.0L I4 engine", actcolor, optical, (1-power)/0.25*2 ); else
		if ( power >= 0.5 ) addPart( parts.engines.I4:0x00000008r, "1.8L I4 engine", actcolor, optical, (0.75-power)/0.25*2 );

		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_02.codrac:0x0000010Cr, "hood", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( optical-1 >= 0.66667 ) addPart( cars.cat_02.codrac:0x0000010Er, "hood 3", actcolor, optical, power ); else
			if ( optical-1 >= 0.33333 ) addPart( cars.cat_02.codrac:0x0000010Dr, "hood 2", actcolor, optical, power ); else
			addPart( cars.cat_02.codrac:0x0000010Cr, "hood", actcolor, optical, power );
		}

		if ( power >= 1.666 ) addPart( parts:0x000000E9r, "silver battery" ); else
		if ( power >= 1.333 ) addPart( parts:0x000000E8r, "blue battery" ); else
		addPart( parts:0x000053FFr, "black battery" );
		
		addPart( cars.cat_02.Codrac:0x0000FFB4r, "steering wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(1,0,1.0); //2WD all becomes FWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}